/****** Object:  StoredProcedure [dbo].[usp_Insert_Discharge_Event]    Script Date: 03/22/2012 11:04:49 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_Insert_Discharge_Event]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_Insert_Discharge_Event]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		silvicap
-- Create date: 24.10.2012
-- Description:	Insert discharge event.
-- =============================================
CREATE PROCEDURE [dbo].[usp_Insert_Discharge_Event] 
	@ID	INT OUTPUT,
	@DOMAIN_ID VARCHAR(50),
	@PATIENT_UID UNIQUEIDENTIFIER,
	@IEN VARCHAR(50),
	@ENTERED_DATE DATETIME,
	@WARD_UID UNIQUEIDENTIFIER,
	@BED_UID UNIQUEIDENTIFIER,
	@VISTA_SITE_UID UNIQUEIDENTIFIER,
	@DISCHARGED_DATE DATETIME,
	@TYPE_OF_MOVEMENT_CODE VARCHAR(100),
	@TYPE_OF_MOVEMENT_CODE_SYSTEM VARCHAR(100),
	@TYPE_OF_MOVEMENT_CODE_SYSTEM_NAME VARCHAR(100),
	@TYPE_OF_MOVEMENT_DISPLAY_NAME VARCHAR(250),
	@ENTERED_BY_UID	UNIQUEIDENTIFIER,
	@ADMISSION_IEN NVARCHAR(20)

AS
SET NOCOUNT ON

BEGIN

	IF EXISTS (SELECT ID FROM DISCHARGE_EVN WHERE IEN = @IEN AND VISTA_SITE_UID = @VISTA_SITE_UID)		
		SELECT @ID = ID FROM DISCHARGE_EVN WHERE IEN = @IEN AND VISTA_SITE_UID = @VISTA_SITE_UID
	ELSE
		BEGIN
			DECLARE @TYPE_OF_MOVEMENT_ID INT, @ADMISSION_ID INT
			SELECT @ADMISSION_ID = ID FROM ADMISSION_EVN WHERE IEN = @ADMISSION_IEN AND VISTA_SITE_UID = @VISTA_SITE_UID
			
			-- TYPE OF MOVEMENT CONCEPT EXISTENCE CHECK
			EXEC dbo.usp_Manage_Concept 
				@CODE = @TYPE_OF_MOVEMENT_CODE, 
				@CODE_SYSTEM = @TYPE_OF_MOVEMENT_CODE_SYSTEM, 
				@CODE_SYSTEM_NAME = @TYPE_OF_MOVEMENT_CODE_SYSTEM_NAME, 
				@DISPLAY_NAME = @TYPE_OF_MOVEMENT_DISPLAY_NAME, 
				@ID = @TYPE_OF_MOVEMENT_ID OUTPUT		

			INSERT INTO DISCHARGE_EVN
			(
				DOMAIN_ID,
				IEN,
				PATIENT_UID,
				ENTERED_DATE, 
				WARD_UID, 
				BED_UID, 
				VISTA_SITE_UID,
				DISCHARGED_DATE, 
				ENTERED_BY_UID, 
				TYPE_OF_MOVEMENT_ID,
				ADMISSION_ID
			)
			VALUES
			(
				@DOMAIN_ID,
				@IEN,
				@PATIENT_UID,
				@ENTERED_DATE, 
				@WARD_UID,
				@BED_UID,
				@VISTA_SITE_UID,
				@DISCHARGED_DATE, 
				@ENTERED_BY_UID,
				@TYPE_OF_MOVEMENT_ID,
				@ADMISSION_ID
			)
			
			SET @ID = IDENT_CURRENT('dbo.DISCHARGE_EVN')

			IF (@ADMISSION_ID IS NOT NULL)
				BEGIN
					UPDATE ADMISSION_EVN
						SET HAS_DISCHARGE = 1
						WHERE ID = @ADMISSION_ID
				END
		END
END
GO
